import { spawn } from "child_process";
export class Pipe {
  input;
  m_output;
  constructor(input, segments) {
    this.input = input;
    this.m_output = this.input;
    for (const segment of segments ?? []) {
      this.add(segment);
    }
  }
  get output() {
    return this.m_output;
  }
  add(segment) {
    const p = spawn(segment.cmd, segment.args, { stdio: "pipe" });
    this.m_output.pipe(p.stdin);
    if (segment.on_close) {
      p.on("close", segment.on_close);
    }
    if (segment.on_stderr) {
      p.stderr.on("data", segment.on_stderr);
    }
    this.m_output = p.stdout;
    return this;
  }
}
