import * as VAPI from "vapi";
import { Duration, Logger } from "vscript";
import { ResourceCount } from "./utils.js";
export interface RTPInterfaces {
    primary: VAPI.NetworkInterfaces.VirtualInterface[];
    secondary: VAPI.NetworkInterfaces.VirtualInterface[];
}
export declare function await_read_delay(rcv: VAPI.Any.RTPReceiver.VideoReceiver | VAPI.Any.RTPReceiver.AudioReceiver, pars?: {
    timeout?: Duration;
    max_jitter_s?: number;
}): Promise<VAPI.Time.TimestampedOffset>;
export declare function lock_to_genlock<R extends VAPI.Any.RTPReceiver.AudioReceiver | VAPI.Any.RTPReceiver.VideoReceiver>(rcv: R): any;
export declare function categorize_sessions<Ss extends VAPI.AT1101.RTPReceiver.Session[] | VAPI.AT1130.RTPReceiver.Session[]>(sessions: Ss): Promise<{
    audio: Ss[0][];
    video: Ss[0][];
    mixed: Ss[0][];
    medialess: Ss[0][];
}>;
export declare function all_tracks_are(t: VAPI.RTPReceiver.Track): (tracks: VAPI.RTPReceiver.UsedSessionTracks | VAPI.RTPReceiver.UsedReceiverTracks) => boolean;
export declare function max_video_capabilities(vm: VAPI.VM.Any): VAPI.Any.RTPReceiver.VideoCapabilities | null;
export declare function create_video_receiver(vm: VAPI.VM.Any, caps?: Partial<VAPI.Any.RTPReceiver.VideoCapabilities>): Promise<VAPI.AT1101.RTPReceiver.VideoReceiverAsNamedTableRow | VAPI.AT1130.RTPReceiver.VideoReceiverAsNamedTableRow>;
export declare function create_audio_receiver(vm: VAPI.VM.Any): Promise<VAPI.AT1101.RTPReceiver.AudioReceiverAsNamedTableRow | VAPI.AT1130.RTPReceiver.AudioReceiverAsNamedTableRow>;
type ReceiverSessions = VAPI.AT1130.RTPReceiver.SessionAsNamedTableRow | VAPI.AT1101.RTPReceiver.SessionAsNamedTableRow | VAPI.AT1130.RTPReceiver.Session | VAPI.AT1101.RTPReceiver.Session;
export declare function switch_to(rxs: ReceiverSessions, sdp: string, pars?: {
    timeout?: Duration;
    ensure_state?: boolean;
    switch_type?: VAPI.RTPReceiver.SwitchType;
    log?: Logger;
}): Promise<() => Promise<boolean>>;
export declare function find_sessions_listening_to_sdp(vm: VAPI.VM.Any, sdp: string): Promise<VAPI.AT1101.RTPReceiver.SessionAsNamedTableRow[] | VAPI.AT1130.RTPReceiver.SessionAsNamedTableRow[]>;
export declare function maximize_buffers(vm: VAPI.VM.Any): Promise<void>;
export declare function reserved_bandwidth(rcv: VAPI.Any.RTPReceiver.VideoReceiver | VAPI.Any.RTPReceiver.AudioReceiver): Promise<{
    bits_per_sec: number;
    ports: Array<VAPI.Any.NetworkInterfaces.Port>;
}>;
export declare function max_video_receivers(pars: {
    vm: VAPI.VM.Any;
    port_indices: (i: number) => number[];
    capabilities: GenlockLessVideoCapabilities;
    preexisting_receivers: "bulldoze" | "preserve";
    log: (msg: string) => void;
    standard?: VAPI.Video.Standard | VAPI.Video.Standard[];
    bandwidth_constraints?: "obey" | "ignore";
}): Promise<number>;
export declare function to_blocks_at1101(buffersize: VAPI.AT1101.RTPReceiver.BufferSize): number;
export declare function to_blocks_at1130(buffersize: VAPI.AT1130.RTPReceiver.BufferSize): number;
export declare function max_audio_receivers(pars: {
    vm: VAPI.VM.Any;
    port_indices: (i: number) => number[];
    capabilities: GenlockLessAudioCapabilities;
    preexisting_receivers: "bulldoze" | "preserve";
    log: (msg: string) => void;
    bandwidth_constraints?: "obey" | "ignore";
}): Promise<number>;
export type GenlockLessAudioCapabilities = Omit<VAPI.AT1130.RTPReceiver.AudioCapabilities, "read_speed"> & {
    read_speed: "LockToGenlock" | "Adaptive";
};
export type GenlockLessVideoCapabilities = Omit<VAPI.AT1130.RTPReceiver.VideoCapabilities, "read_speed"> & {
    read_speed: "LockToGenlock" | "Adaptive";
};
export declare function to_video_capabilities(tf: VAPI.Video.TransportFormat, std?: VAPI.Video.Standard): Partial<GenlockLessVideoCapabilities>;
export declare function has_caliber_set(cap: Partial<GenlockLessVideoCapabilities>): boolean;
export declare function video_capability_union(cap1: Partial<GenlockLessVideoCapabilities>, cap2: Partial<GenlockLessVideoCapabilities>): Partial<GenlockLessVideoCapabilities>;
export declare function setup_video_receivers(pars: {
    count: ResourceCount;
    vms: VAPI.VM.Any[];
    port_indices: (i_rcv: number) => number[];
    capabilities: Partial<GenlockLessVideoCapabilities>;
    preexisting_receivers: "bulldoze" | "preserve";
    log: (msg: string) => void;
    bandwidth_constraints?: "obey" | "ignore";
    verbose?: boolean;
}): Promise<VAPI.AT1101.RTPReceiver.VideoReceiverAsNamedTableRow[] | VAPI.AT1130.RTPReceiver.VideoReceiverAsNamedTableRow[]>;
export declare function setup_audio_receivers(pars: {
    count: ResourceCount;
    vms: VAPI.VM.Any[];
    port_indices: (i_rcv: number) => number[];
    capabilities: Partial<GenlockLessAudioCapabilities>;
    preexisting_receivers: "bulldoze" | "preserve";
    log: (msg: string) => void;
    verbose?: boolean;
}): Promise<VAPI.AT1101.RTPReceiver.AudioReceiverAsNamedTableRow[] | VAPI.AT1130.RTPReceiver.AudioReceiverAsNamedTableRow[]>;
export {};
