import * as VAPI from "vapi";
import { InterfaceSelector } from "./network.js";
import { ResourceCount } from "./utils.js";
export type DstAddressFn = (pars: {
    src: string;
    mediaType: "audio" | "video" | "meta" | "passthrough" | "mipmap";
    transmitterIndex: number;
    mid: "primary" | "secondary";
}) => string;
export declare function canonicalizeDstAddresses(media_stream: VAPI.Any.RTPTransmitter.MediaStreamer | VAPI.Any.RTPTransmitter.MediaStreamerVideo, mode: "set" | "check", media_stream_index: number, dst_address_fn: DstAddressFn): Promise<void>;
export declare function force_activate(tx: VAPI.Any.RTPTransmitter.Session): Promise<string>;
export type AnyStreamer = VAPI.Any.RTPTransmitter.AudioStreamer | VAPI.Any.RTPTransmitter.VideoStreamer;
export declare function get_hosting_session(streamer: AnyStreamer): Promise<VAPI.Any.RTPTransmitter.Session>;
export declare function deactivate_hosting_session(streamer: AnyStreamer): Promise<void>;
export declare function force_activate_hosting_session(streamer: AnyStreamer): Promise<string>;
export declare function set_transport_format(tf: VAPI.Video.TransportFormat, vtf: VAPI.Any.RTPTransmitter.VideoStreamer, meta?: boolean): Promise<void>;
export declare function get_packets_per_second(tx: VAPI.Any.RTPTransmitter.VideoStreamer | VAPI.Any.RTPTransmitter.AudioStreamer): Promise<VAPI.EthernetStats.Counter>;
export type PartialVideoFormat = {
    variant: "ST2022_6";
    value: Partial<VAPI.RTPTransmitter.ST20226Settings>;
} | {
    variant: "ST2110_20";
    value: Partial<VAPI.AT1101.RTPTransmitter.ST2110Settings> | Partial<VAPI.AT1130.RTPTransmitter.ST2110Settings>;
} | {
    variant: "ST2042";
    value: Partial<VAPI.RTPTransmitter.ST2042Settings>;
} | {
    variant: "JPEG_XS";
    value: Partial<VAPI.RTPTransmitter.JpegXsSettings>;
};
export type PartialVideoRequirements = {
    add_st2110_40?: boolean;
    transmit_scheduler_uhd?: boolean;
};
export declare function audio_bandwidth_estimate(pars: {
    transport_format: VAPI.RTPTransmitter.AudioConfigurationFormat;
}): {
    bits_per_sec: number;
};
export declare function bandwidth_estimate(pars: {
    std?: VAPI.Video.Standard;
    transport_format: PartialVideoFormat | VAPI.Any.RTPTransmitter.VideoFormat;
}): {
    bits_per_sec: number;
};
export declare function reserved_bandwidth(tx: VAPI.Any.RTPTransmitter.VideoStreamer | VAPI.Any.RTPTransmitter.AudioStreamer): Promise<{
    bits_per_sec: number;
    ports: Array<VAPI.Any.NetworkInterfaces.Port>;
}>;
export declare function max_video_transmitters(pars: {
    vm: VAPI.VM.Any;
    port_indices: (i: number) => number[];
    transport_format: VAPI.Any.RTPTransmitter.VideoFormat | PartialVideoFormat;
    preexisting_transmitters: "bulldoze" | "preserve";
    log: (msg: string) => void;
    standard?: VAPI.Video.Standard | VAPI.Video.Standard[];
    bandwidth_constraints?: "obey" | "ignore";
}): Promise<number>;
export declare function max_audio_transmitters(pars: {
    vm: VAPI.VM.Any;
    port_indices: (i: number) => number[];
    transport_format: VAPI.RTPTransmitter.AudioConfigurationFormat;
    preexisting_transmitters: "bulldoze" | "preserve";
    log: (msg: string) => void;
    bandwidth_constraints?: "obey" | "ignore";
}): Promise<number>;
export declare function to_partial_config(tf: VAPI.Video.TransportFormat | VAPI.Any.RTPTransmitter.VideoFormat | PartialVideoFormat): PartialVideoFormat;
export declare function setup_video_transmitters(pars: {
    count: ResourceCount;
    vms: VAPI.VM.Any[];
    port_indices: (tx_index: number) => number[];
    transport_format: VAPI.Video.TransportFormat | VAPI.Any.RTPTransmitter.VideoFormat | PartialVideoFormat;
    requirements?: PartialVideoRequirements;
    preexisting_transmitters: "bulldoze" | "preserve";
    log: (msg: string) => void;
    address_schema: DstAddressFn;
    standard?: VAPI.Video.Standard | VAPI.Video.Standard[];
    bandwidth_constraints?: "obey" | "ignore";
    verbose?: boolean;
    pattern?: VAPI.VideoSignalGenerator.TestPatternSelect;
}): Promise<VAPI.AT1101.RTPTransmitter.VideoStreamerAsNamedTableRow[] | VAPI.AT1130.RTPTransmitter.VideoStreamerAsNamedTableRow[]>;
export declare function setup_audio_transmitters(pars: {
    count: ResourceCount;
    vms: VAPI.VM.Any[];
    port_indices: (tx_index: number) => number[];
    transport_format?: Partial<VAPI.RTPTransmitter.AudioConfigurationFormat>;
    preexisting_transmitters: "bulldoze" | "preserve";
    log: (msg: string) => void;
    address_schema: DstAddressFn;
    bandwidth_constraints?: "obey" | "ignore";
    verbose?: boolean;
}): Promise<VAPI.AT1101.RTPTransmitter.AudioStreamerAsNamedTableRow[] | VAPI.AT1130.RTPTransmitter.AudioStreamerAsNamedTableRow[]>;
export declare function abandon(pars: {
    tx: VAPI.Any.RTPTransmitter.AudioStreamer | VAPI.Any.RTPTransmitter.VideoStreamer;
    delete_session_if_unused: boolean;
}): Promise<void>;
export declare function transport_defaults(vf: PartialVideoFormat): VAPI.AT1130.RTPTransmitter.VideoFormat;
export type AddressTuple = {
    primary: string;
    secondary: string;
};
export type AddressPackage = {
    media: AddressTuple;
    meta?: AddressTuple;
};
export declare function make_mcast(tx: VAPI.AT1101.RTPTransmitter.AudioStreamerAsNamedTableRow | VAPI.AT1130.RTPTransmitter.AudioStreamerAsNamedTableRow | VAPI.AT1101.RTPTransmitter.VideoStreamerAsNamedTableRow | VAPI.AT1130.RTPTransmitter.VideoStreamerAsNamedTableRow, rtp?: {
    primary: string | null;
    secondary: string | null;
}): Promise<AddressPackage>;
export declare function stream_out(src: VAPI.AT1130.Video.Essence | VAPI.AT1101.Video.Essence | VAPI.AT1130.Audio.Essence | VAPI.AT1101.Audio.Essence): Promise<VAPI.AT1101.RTPTransmitter.VideoStreamerAsNamedTableRow | VAPI.AT1101.RTPTransmitter.AudioStreamerAsNamedTableRow | VAPI.AT1130.RTPTransmitter.VideoStreamerAsNamedTableRow | VAPI.AT1130.RTPTransmitter.AudioStreamerAsNamedTableRow>;
export declare function stream_video(src: VAPI.AT1130.Video.Essence | VAPI.AT1101.Video.Essence, pars?: {
    transport_format?: PartialVideoFormat;
    eps?: boolean;
    addresses?: AddressPackage;
    constrain?: boolean;
    swap_interfaces?: boolean;
    vanc?: VAPI.Definitions.BypassReplaceFlags;
    a_src?: VAPI.AT1101.Audio.Essence | VAPI.AT1130.Audio.Essence;
    vid_std_override?: VAPI.Video.Standard;
}): Promise<VAPI.AT1130.RTPTransmitter.VideoStreamerAsNamedTableRow | VAPI.AT1101.RTPTransmitter.VideoStreamerAsNamedTableRow>;
export declare function stream_video(src: VAPI.AT1130.Video.Essence | VAPI.AT1101.Video.Essence, pars?: {
    transport_format?: PartialVideoFormat;
    addresses?: AddressPackage;
    constrain?: boolean;
    interface_selector?: InterfaceSelector;
    vanc?: VAPI.Definitions.BypassReplaceFlags;
    a_src?: VAPI.AT1101.Audio.Essence | VAPI.AT1130.Audio.Essence;
    vid_std_override?: VAPI.Video.Standard;
}): Promise<VAPI.AT1130.RTPTransmitter.VideoStreamerAsNamedTableRow | VAPI.AT1101.RTPTransmitter.VideoStreamerAsNamedTableRow>;
type StreamAudioPars = {
    format: VAPI.RTPTransmitter.AudioConfigurationFormat;
    addresses?: AddressPackage;
    interface_selector?: InterfaceSelector;
};
export declare function do_stream_audio(src: VAPI.AT1130.Audio.Essence | VAPI.AT1101.Audio.Essence, params?: Partial<StreamAudioPars>): Promise<VAPI.AT1101.RTPTransmitter.AudioStreamerAsNamedTableRow | VAPI.AT1130.RTPTransmitter.AudioStreamerAsNamedTableRow>;
export declare function stream_audio(src: VAPI.AT1130.Audio.Essence | VAPI.AT1101.Audio.Essence, params?: {
    format?: VAPI.RTPTransmitter.AudioConfigurationFormat;
    addresses?: AddressPackage;
    eps?: boolean;
    swap_interfaces?: boolean;
}): Promise<VAPI.AT1101.RTPTransmitter.AudioStreamerAsNamedTableRow | VAPI.AT1130.RTPTransmitter.AudioStreamerAsNamedTableRow>;
export declare function stream_audio(src: VAPI.AT1130.Audio.Essence | VAPI.AT1101.Audio.Essence, params?: {
    format?: VAPI.RTPTransmitter.AudioConfigurationFormat;
    addresses?: AddressPackage;
    interface_selector?: InterfaceSelector;
}): Promise<VAPI.AT1101.RTPTransmitter.AudioStreamerAsNamedTableRow | VAPI.AT1130.RTPTransmitter.AudioStreamerAsNamedTableRow>;
export {};
